Scriptname SS_DRB_ShipServicesRepairCost extends ReferenceAlias
{ Updates ship repair cost on settings change, landing, and docking }

actorvalue property Health auto const mandatory
globalvariable property ShipServicesRepairCost auto const mandatory
globalvariable property SS_DRB_Calculation auto const mandatory
globalvariable property SS_DRB_Multiplier auto const mandatory
quest property DialogueShipServices auto const mandatory
SQ_PlayerShipScript property SQ_PlayerShip auto const mandatory

;	Dialogue events don't update ShipServicesRepairCost immediately, as much as I'd prefer to use them.
;Event OnInit()
;	RegisterForMenuOpenCloseEvent("DialogueMenu")
;EndEvent
;
;Event OnMenuOpenCloseEvent(string asMenuName, bool abOpening)
;	if abOpening
;		UpdateCost()
;	endif
;EndEvent

Event OnInit()
    RegisterForGameplayOptionChangedEvent()
EndEvent

Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)
	Utility.Wait(0.1)
	Self.UpdateCost()
EndEvent

Event OnShipLanding(Bool abComplete)
	Self.UpdateCost()
EndEvent

Event OnShipDock(Bool abComplete, spaceshipreference akDocking, spaceshipreference akParent)
	Self.UpdateCost()
EndEvent

Function UpdateCost()
	SpaceshipReference PlayerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	float PlayerShipHealth = PlayerShipRef.GetValue(Health)
	float PlayerShipHealthMax = PlayerShipRef.GetBaseValue(Health)
	float PlayerShipRepairCost = 1000
	if SS_DRB_Calculation.GetValue() == 1 ; Percentage
		PlayerShipRepairCost = 1000 - (( PlayerShipHealth * 1000 ) / PlayerShipHealthMax )
	elseif SS_DRB_Calculation.GetValue() == 2 ; Point based
		PlayerShipRepairCost = ( PlayerShipHealthMax - PlayerShipHealth ) * 6
	endif
	if PlayerShipRepairCost < 100
		PlayerShipRepairCost = 100
	endif
	PlayerShipRepairCost *= SS_DRB_Multiplier.GetValue()
	ShipServicesRepairCost.SetValueInt(PlayerShipRepairCost as Int)
	DialogueShipServices.UpdateCurrentInstanceGlobal(ShipServicesRepairCost)
EndFunction